<?php
/**
 * Logout Handler
 * 
 * Ends the current user session and redirects to the login page
 */

// Start session
session_start();

// Unset all session variables
$_SESSION = array();

// If a session cookie is used, destroy it
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Destroy the session
session_destroy();

// Redirect ke dashboard_guest.php setelah logout
header("Location: dashboard_guest.php");
exit; 