<?php
require_once '../config/db_config.php';
session_start();

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header('Location: listProduct.php');
    exit;
}
$product_id = (int)$_GET['id'];

$db = getDbConnection();

try {
    $stmt = $db->prepare("DELETE FROM products WHERE product_id = :id");
    $stmt->bindParam(':id', $product_id);
    $stmt->execute();
    header('Location: listProduct.php?success=delete');
    exit;
} catch (PDOException $e) {
    header('Location: listProduct.php?error=delete');
    exit;
} 