<?php /* Komponen Sidebar Admin dengan burger menu */ ?>
<?php
// Pastikan Font Awesome hanya di-include sekali
if (!defined('ADMIN_SIDEBAR_FA_INCLUDED')) {
    define('ADMIN_SIDEBAR_FA_INCLUDED', true);
    echo '<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">';
}
?>
<style>
    .sidebar {
        min-height: 100vh;
        background-color: #343a40;
        padding-top: 20px;
        transition: left 0.3s;
        position: relative;
        z-index: 1;
        width: 100%; /* agar grid Bootstrap bekerja normal di desktop */
    }
    .sidebar a {
        color: #fff;
        text-decoration: none;
        padding: 10px 20px;
        display: block;
    }
    .sidebar a:hover {
        background-color: #495057;
    }
    .sidebar a.active {
        background-color: #0d6efd;
    }
    @media (max-width: 991.98px) {
        .sidebar {
            position: fixed;
            left: -250px;
            top: 0;
            width: 250px;
            z-index: 1050;
            height: 100vh;
        }
        .sidebar.show {
            left: 0;
        }
        .sidebar-backdrop {
            display: none;
            position: fixed;
            top: 0; left: 0; right: 0; bottom: 0;
            background: rgba(0,0,0,0.3);
            z-index: 1049;
        }
        .sidebar-backdrop.show {
            display: block;
        }
    }
</style>
<!-- Burger menu button (mobile only) -->
<div class="d-lg-none p-2 bg-dark text-white">
    <button id="sidebarToggle" class="btn btn-outline-light">
        <i class="fas fa-bars"></i>
    </button>
    <span class="ms-2">Admin Panel</span>
</div>
<!-- Sidebar -->
<div id="adminSidebar" class="sidebar">
    <div class="text-center mb-4">
        <h4 class="text-white">Admin Panel</h4>
    </div>
    <nav>
        <a href="dashboard.php" class="<?= basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : '' ?>">
            <i class="fas fa-tachometer-alt me-2"></i> Dashboard
        </a>
        <a href="orders.php" class="<?= basename($_SERVER['PHP_SELF']) == 'orders.php' ? 'active' : '' ?>">
            <i class="fas fa-shopping-cart me-2"></i> Pesanan
        </a>
        <a href="verify_payment.php" class="<?= basename($_SERVER['PHP_SELF']) == 'verify_payment.php' ? 'active' : '' ?>">
            <i class="fas fa-money-bill me-2"></i> Verifikasi Pembayaran
        </a>
        <!-- Hapus menu Produk yang mengarah ke add_product.php -->
        <!--<a href="add_product.php" class="<?= basename($_SERVER['PHP_SELF']) == 'add_product.php' ? 'active' : '' ?>">
            <i class="fas fa-box me-2"></i> Produk
        </a>-->
        <a href="users.php" class="<?= basename($_SERVER['PHP_SELF']) == 'users.php' ? 'active' : '' ?>">
            <i class="fas fa-users me-2"></i> Pengguna
        </a>
        <a href="listProduct.php" class="<?= basename($_SERVER['PHP_SELF']) == 'listProduct.php' ? 'active' : '' ?>">
            <i class="fas fa-list me-2"></i> List Produk
        </a>
        <a href="logout.php">
            <i class="fas fa-sign-out-alt me-2"></i> Logout
        </a>
    </nav>
</div>
<div id="sidebarBackdrop" class="sidebar-backdrop"></div>
<script>
    // Sidebar toggle for mobile
    const sidebar = document.getElementById('adminSidebar');
    const sidebarToggle = document.getElementById('sidebarToggle');
    const sidebarBackdrop = document.getElementById('sidebarBackdrop');
    if (sidebarToggle) {
        sidebarToggle.addEventListener('click', function() {
            sidebar.classList.toggle('show');
            sidebar.classList.remove('d-none');
            sidebarBackdrop.classList.toggle('show');
        });
    }
    if (sidebarBackdrop) {
        sidebarBackdrop.addEventListener('click', function() {
            sidebar.classList.remove('show');
            sidebarBackdrop.classList.remove('show');
        });
    }
    // Hide sidebar on resize to desktop
    window.addEventListener('resize', function() {
        if (window.innerWidth >= 992) {
            sidebar.classList.remove('show');
            sidebarBackdrop.classList.remove('show');
            sidebar.classList.add('d-lg-block');
        }
    });
</script> 