<?php
require_once(__DIR__ . '/../config/db_config.php');
session_start();
if (!isset($_SESSION['user_id'])) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['order_code'])) {
    $order_code = $_POST['order_code'];
    $db = getDbConnection();
    $stmt = $db->prepare("UPDATE orders SET status = 'delivered' WHERE order_code = :order_code AND user_id = :user_id");
    $stmt->bindParam(':order_code', $order_code);
    $stmt->bindParam(':user_id', $_SESSION['user_id']);
    if ($stmt->execute()) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Update failed']);
    }
    exit;
}
echo json_encode(['success' => false, 'message' => 'Invalid request']); 