<?php
require_once(__DIR__ . '/../config/db_config.php');
require_once '../models/Order.php';

if (!isset($_GET['order_id'])) {
    die('Order ID tidak ditemukan.');
}

$order_id = $_GET['order_id'];
$order = new Order();
if (!$order->getOrderByOrderCode($order_id)) {
    die('Order tidak ditemukan.');
}
$order_details = $order;
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Invoice - <?php echo htmlspecialchars($order_details->order_code); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .invoice-box {
            max-width: 700px;
            margin: 40px auto;
            padding: 30px;
            border: 1px solid #eee;
            background: #fff;
            border-radius: 10px;
        }
        .invoice-title {
            font-size: 2rem;
            font-weight: bold;
            margin-bottom: 20px;
        }
        .table th, .table td {
            vertical-align: middle;
        }
    </style>
</head>
<body>
<div class="invoice-box">
    <div class="invoice-title">Invoice</div>
    <div class="mb-3">
        <strong>Kode Pesanan:</strong> <?php echo htmlspecialchars($order_details->order_code); ?><br>
        <strong>Nama:</strong> <?php echo htmlspecialchars($order_details->name); ?><br>
        <strong>Email:</strong> <?php echo htmlspecialchars($order_details->email); ?><br>
        <strong>Status:</strong> <?php echo htmlspecialchars($order_details->status); ?><br>
        <strong>Tanggal:</strong> <?php echo htmlspecialchars($order_details->created_at); ?><br>
        <?php if (strtolower($order_details->shipping_label) === 'jne' && !empty($order_details->resi)): ?>
            <strong>No Resi:</strong> <?php echo htmlspecialchars($order_details->resi); ?><br>
        <?php endif; ?>
    </div>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Produk</th>
                <th>Harga</th>
                <th>Jumlah</th>
                <th>Subtotal</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($order_details->items as $item): ?>
            <tr>
                <td><?php echo htmlspecialchars($item['product_name']); ?></td>
                <td>Rp <?php echo number_format($item['product_price'], 0, ',', '.'); ?></td>
                <td><?php echo $item['quantity']; ?></td>
                <td>Rp <?php echo number_format($item['subtotal'], 0, ',', '.'); ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr>
                <th colspan="3" class="text-end">Total</th>
                <th>Rp <?php echo number_format($order_details->total_amount, 0, ',', '.'); ?></th>
            </tr>
        </tfoot>
    </table>
    <div class="text-center mt-4">
        <button class="btn btn-primary" onclick="window.print()">Cetak Invoice</button>
    </div>
</div>
</body>
</html> 