<?php
/**
 * Password Checker Tool
 * 
 * This tool verifies if the entered password matches the hash stored in database
 * and can create a new password hash for admin user.
 */

// Define expected admin credentials
$admin_username = 'admin';
$admin_password = 'admin123';

// Hash from database (from SQL file)
$db_hash = '$2y$10$uIp8H64A.mMoYXbQcvLOjeRNZLOcUK5A/0OOUMjKJ3bZlkSZhZM4W';

// Check if the hardcoded 'admin123' password verifies against the hash in database
$verify_result = password_verify($admin_password, $db_hash);

// Generate a new hash for admin123 for comparison
$new_hash = password_hash($admin_password, PASSWORD_DEFAULT);

// Display results
echo "<h2>Password Check Results</h2>";
echo "<p><strong>Username:</strong> $admin_username</p>";
echo "<p><strong>Password:</strong> $admin_password</p>";
echo "<p><strong>Hash from database:</strong> $db_hash</p>";
echo "<p><strong>New hash generated:</strong> $new_hash</p>";
echo "<p><strong>Verification result:</strong> " . ($verify_result ? "MATCH ✓" : "NO MATCH ✗") . "</p>";

// If password doesn't match, provide SQL to update the password
if (!$verify_result) {
    echo "<h2>SQL to Update Password</h2>";
    echo "<code>UPDATE users SET password = '$new_hash' WHERE username = 'admin';</code>";
    
    // Include database configuration
    require_once 'config/db_config.php';
    
    echo "<h2>Auto-Fix Password</h2>";
    echo "<form method='post'>";
    echo "<button type='submit' name='fix_password' style='background-color: #4CAF50; color: white; padding: 10px 15px; border: none; border-radius: 4px; cursor: pointer;'>Fix Password Now</button>";
    echo "</form>";
    
    // Check if the form is submitted
    if (isset($_POST['fix_password'])) {
        try {
            // Get database connection
            $db = getDbConnection();
            if (!$db) {
                throw new Exception("Database connection failed.");
            }
            
            // Update the password
            $stmt = $db->prepare("UPDATE users SET password = :password WHERE username = :username");
            $stmt->bindParam(':password', $new_hash);
            $stmt->bindParam(':username', $admin_username);
            $stmt->execute();
            
            if ($stmt->rowCount() > 0) {
                echo "<p style='color: green; font-weight: bold;'>Password berhasil diperbarui!</p>";
                echo "<p>Sekarang Anda dapat login dengan username 'admin' dan password 'admin123'</p>";
                echo "<p><a href='login-admin.php' style='color: blue;'>Login Sekarang</a></p>";
            } else {
                echo "<p style='color: orange;'>Tidak ada perubahan dilakukan. Username 'admin' tidak ditemukan.</p>";
            }
        } catch (Exception $e) {
            echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
        }
    }
} 