<?php
require_once '../config/db_config.php';
session_start();

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../login.php');
    exit;
}

$db = getDbConnection();
$orders = [];
$error = '';

try {
    $stmt = $db->query("SELECT * FROM orders ORDER BY created_at DESC");
    $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $error = 'Database error: ' . $e->getMessage();
}

function formatRupiah($amount) {
    return 'Rp ' . number_format($amount, 0, ',', '.');
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Pesanan - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-2 p-0">
                <?php include 'admin_sidebar.php'; ?>
            </div>
            <div class="col-lg-10 p-4">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1>Daftar Pesanan</h1>
                    <a href="dashboard.php" class="btn btn-outline-primary">Kembali ke Dashboard</a>
                </div>
                <?php if ($error): ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Kode Pesanan</th>
                                <th>Nama</th>
                                <th>Email</th>
                                <th>Total</th>
                                <th>Tanggal</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($orders as $order): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($order['order_code']); ?></td>
                                    <td><?php echo htmlspecialchars($order['name']); ?></td>
                                    <td><?php echo htmlspecialchars($order['email']); ?></td>
                                    <td><?php echo formatRupiah($order['total_amount']); ?></td>
                                    <td><?php echo date('d/m/Y H:i', strtotime($order['created_at'])); ?></td>
                                    <td>
                                        <?php
                                        switch ($order['status']) {
                                            
                                            case 'paid':
                                                echo '<span class="text-primary fw-bold">Sedang diproses</span>';
                                                break;
                                            case 'processing':
                                                echo '<span class="text-primary fw-bold">Sedang diproses</span>';
                                                break;
                                            
                                            case 'delivered':
                                                echo '<span class="text-success fw-bold">Selesai</span>';
                                                break;
                                            case 'cancelled':
                                                echo '<span class="text-danger fw-bold">Dibatalkan</span>';
                                                break;
                                            default:
                                                echo '<span class="text-secondary">-</span>';
                                        }
                                        ?>
                                        <a href="order_detail.php?id=<?php echo $order['order_id']; ?>" class="btn btn-sm btn-primary ms-2">Detail</a>
                                        <a href="delete_order.php?id=<?php echo $order['order_id']; ?>" class="btn btn-sm btn-danger ms-2" onclick="return confirm('Yakin ingin menghapus pesanan ini?')">Hapus</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</body>
</html> 